<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Block extends Model 
{

    protected $table = 'blocks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function type()
    {
        return $this->hasOne('App\Models\BlockType');
    }

    public function rooms()
    {
        return $this->hasMany('App\Models\Room');
    }

}